﻿using System.Collections.Generic;
using System.Diagnostics;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Vista.Links;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VIMT.VIASchedulingService.Messages;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.CancelAppointment
{
    public class SendBothAppointmentsToEcStep:FilterBase<CancelAppointmentStateObject>
    {
        public override void Execute(CancelAppointmentStateObject state)
        {
            if (!string.IsNullOrEmpty(state.CancelAppointmentFakeResponseType))
            {
                state.PatEcResponse = VistaFakeResponses.FakeCancelAppointmentResponse(state.CancelAppointmentFakeResponseType, state.PatEcRequest);
                state.ProEcResponse = VistaFakeResponses.FakeCancelAppointmentResponse(state.CancelAppointmentFakeResponseType, state.ProEcRequest);
                return;
            }
            var requestKvps = new List<KeyValuePair<string, VIMTVIASchedCancApcancelAppointmentRequest>>
            {
                new KeyValuePair<string, VIMTVIASchedCancApcancelAppointmentRequest>("Pat", state.PatEcRequest),
                new KeyValuePair<string, VIMTVIASchedCancApcancelAppointmentRequest>("Pro", state.ProEcRequest)
            };

            var timer = new Stopwatch();
            timer.Start();
            Parallel.ForEach(requestKvps, request =>
            {
                if (request.Key == "Pat" && state.PatEcRequest != null)
                    state.PatEcResponse = state.PatEcRequest.SendReceive<VIMTVIASchedCancApcancelAppointmentResponse>(MessageProcessType.Local);
                if (request.Key == "Pro" && state.ProEcRequest != null)
                    state.ProEcResponse = state.ProEcRequest.SendReceive<VIMTVIASchedCancApcancelAppointmentResponse>(MessageProcessType.Local);
            });
            timer.Stop();
            state.EcProcessingTimeMs += (int)timer.ElapsedMilliseconds;
        }
    }
}
